const EmployeeTypeNames = {
    Developer: 'Developer',
    LeadDeveloper: 'LeadDeveloper',
    Designer: 'Designer',
    SalesExecutive: 'SalesExecutive',
    CustomerServiceAgent: 'CustomerServiceAgent',
    ChiefTechnologyOfficer: 'ChiefTechnologyOfficer',
    Manager: 'Manager',
    Researcher: 'Researcher',
    DevOps: 'DevOps',
    HrManager: 'HrManager',
    Marketer: 'Marketer'
};

const GameEvents = {
    WorkstationChange: 'WorkstationChange',
    EmployeeChange: 'EmployeeChange',
    GridChange: 'GridChange',
    ResearchChange: 'ResearchChange',
    ProductChange: 'ProductChange',
    ContractChange: 'ContractChange',
    ClientChange: 'ClientChange',
    SelectedWorkstationChange: 'SelectedWorkstationChange',
    LoanChange: 'LoanChange',
    InventoryChange: 'InventoryChange',
    SpeedChange: 'SpeedChange',
    CandidateChange: 'CandidateChange',
    OnNewHour: 'OnNewHour',
    MenuChange: 'MenuChange'
};

const EmployeeLevels = {
    Beginner: 'Beginner',
    Intermediate: 'Intermediate',
    Expert: 'Expert'
};

const Priorities = {
    Low: 'Low',
    Medium: 'Medium',
    High: 'High'
};

const ContractStatuses = {
    NotSet: 'NotSet',
    Declined: 'Declined',
    OfferSent: 'OfferSent',
    Won: 'Won',
    Lost: 'Lost',
    Cancelled: 'Cancelled'
};

const ContractTypes = {
    FixedPrice: 'FixedPrice',
    LimitedRFQ: 'LimitedRFQ'
};

const ComponentTypes = {
    Component: 'Component',
    Module: 'Module',
    Server: 'Server'
};

const Enums = {
    PlatformNames: {
        Web: 'Web',
        Mobile: 'Mobile',
        Desktop: 'Desktop'
    },
    EmployeeTypeGroups: {
        Development: 'Development',
        Sales: 'Sales',
        Management: 'Management'
    },
    EmployeeStates: {
        OnVacation: 'OnVacation',
        Sick: 'Sick',
        Working: 'Working',
        Idle: 'Idle',
        Awaiting: 'Awaiting',
        Unassigned: 'Unassigned'
    },
    TaskStates: {
        Running: 'Running',
        Stalled: 'Stalled',
        Completed: 'Completed',
        Stopped: 'Stopped'
    },
    NotificationTypes: {
        Info: 'Info',
        Warning: 'Warning',
    }
};

const TASK_BASED_EMPLOYEE_TYPES = [EmployeeTypeNames.Designer,EmployeeTypeNames.Developer,
    EmployeeTypeNames.SalesExecutive, EmployeeTypeNames.LeadDeveloper, EmployeeTypeNames.Researcher,
    EmployeeTypeNames.Marketer, EmployeeTypeNames.DevOps];